
# OAuth

__OAuth("Open Authorization")__ 는 인터넷 사용자들이 비밀번호를 제공하지 않고 다른 웹사이트 상의 자신들의 정보에 대해 웹사이트나 애플리케이션의 접근 권한을 부여할 수 있는 공통적인 수단으로서 사용되는, 접근 위임을 위한 개방형 표준이다.

>__예)__ 초성편지 서비스(외부 애플리케이션)는 사용자 인증을 위해 Kakao의 사용자 인증 방식을 사용한다. 이때, OAuth를 바탕으로 초성편지(제 3자 서비스)는 Kakao(외부 서비스)의 특정 자원을 접근 및 사용할 수 있는 권한을 인가받게 된다.

## OAuth 참여자
OAuth 동작에 관여하는 참여자는 크게 세 가지로 구분할 수 있다.  

* __Resource Server__ : Client가 제어하고자 하는 자원을 보유하고 있는 서버. Facebook, Google, Twitter 등이 이에 속함.
* __Resource Owner__ : 자원의 소유자. Client가 제공하는 서비스를 통해 로그인하는 실제 유저가 이에 속함.
* __Client__ : Resoure Server에 접속해서 정보를 가져오고자 하는 클라이언트(웹 어플리케이션).

## OAuth 용어
* __사용자(user)__: 서비스 제공자와 소비자를 사용하는 계정을 가지고 있는 개인
* __소비자(consumer)__: Open API를 이용하여 개발된 OAuth를 사용하여 서비스 제공자에게 접근하는 웹사이트 또는 애플리케이션
* __서비스 제공자(service provider)__: OAuth를 통해 접근을 지원하는 웹 애플리케이션(Open API를 제공하는 서비스)
* __소비자 비밀번호(consumer secret)__ : 서비스 제공자에서 소비자가 자신임을 인증하기 위한 키
* __요청 토큰(request token)__ : 소비자가 사용자에게 접근권한을 인증받기 위해 필요한 정보가 담겨있으며 후에 접근 토큰으로 변환된다.
* __접근 토큰(access token)__ : 인증 후에 사용자가 서비스 제공자가 아닌 소비자를 통해서 보호된 자원에 접근하기 위한 키를 포함한 값.

## OAuth 인증방식

![oauth2 0-process](https://user-images.githubusercontent.com/70997596/207482844-0810146a-4fd8-4f8f-a1c4-7e66f573a188.png)

1. 소비자가 서비스제공자에게 요청토큰을 요청한다.
2. 소비자가 사용자를 서비스제공자로 이동시킨다. 여기서 사용자 인증이 수행된다.
3. 서비스제공자가 사용자를 소비자로 이동시킨다.
4. 서비스제공자가 소비자에게 요청토큰을 발급해준다.
5. 소비자가 접근토큰을 요청한다.
6. 서비스제공자가 접근토큰을 발급한다.
7. 발급된 접근토큰을 이용하여 소비자에서 사용자 정보에 접근한다.
***
## 출처
https://tecoble.techcourse.co.kr/post/2021-07-10-understanding-oauth/  
https://ko.wikipedia.org/wiki/OAuth  
https://hudi.blog/oauth-2.0/
